﻿//=============================================================================
//
//          Copyright (c) 2022 Beijing Dreamagic Science and Technology Co.,Ltd.
//                          All Rights Reserved.
//
//=============================================================================
using Newtonsoft.Json;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Scripting;

namespace Qiyu.Sdk.Platform
{
    public static class QiyuMessage
    {
        [Preserve]
        public class MessageResult<T>
        {
            public T data;
            public string code;  //返回码
            public string message; //错误信息
            public bool IsSuccess()
            {
                return code.Equals("S0000");
            }

            public string ToJson()
            {
                return QiyuUtils.ParseToJson(this);
            }
        }

        public static RequestCallback GetRequestResult<T>(System.Action<MessageResult<T>> callback)
        {
            return RequestCallbackByJson<MessageResult<T>>.Create((MessageResult<T> msg1) =>
            {
                callback?.Invoke(msg1);
            });
        }

        [Preserve]
        public class SDKInit
        {

        }

        [Preserve]
        public class QiyuAccountInfo
        {
            public string uid;  //用户uid
            public string name; //用户名
            public string icon; //头像地址
        }

        [Preserve]
        public class DeepLinkParam
        {
            public string appID;
            public string key;
            public string value;

            public string ToJson()
            {
                return QiyuUtils.ParseToJson(this);
            }
        }

        [Preserve]
        public class QiyuPaySkuInfo
        {
            //1:持久型,2:消耗型
            public const int TYPE_NON_CONSUMABLE = 1;
            public const int TYPE_CONSUMABLE = 2;
            //10:预发布,20:正常,-1:无效
            public const int STATUS_INVALID = -1;
            public const int STATUS_PRE_RELEASE = 10;
            public const int STATUS_RELEASE = 20;

            public string sku;
            public string productName;
            public int itemType;
            public float originalPrice;//单位元
            public float salePrice;//单位元
            public int status;

            public override string ToString()
            {
                return string.Format("sku:{0},productName:{1},itemType:{2},originalPrice:{3},salePrice:{4},status:{5}", sku, productName, itemType, originalPrice, salePrice, status);
            }
        }

        [Preserve]
        public class QiyuPayOrderResult
        {
            public const int STATUS_SUCCESS = 40;

            public long orderId;
            public string sku;
            public int orderStatus;
            public float paidAmount;
            public string payDate;

            public override string ToString()
            {
                return string.Format("orderId:{0},sku:{1},orderStatus:{2},paidAmount:{3},payDate:{4}", orderId, sku, orderStatus, paidAmount, payDate);
            }
        }

        [Preserve]
        public class QiyuPayHistoryOrders
        {
            public int count;
            public List<QiyuPayOrderResult> orders;
        }

        [Preserve]
        public class QiyuDlcAssetDetails
        {
            public int count;
            public List<QiyuDlcAssetDetail> items;
        }

        [Preserve]
        public class QiyuDlcAssetDetail
        {
            public const int ASSET_TYPE_PERSISTENT = 1;//持久型dlc
            public const int ASSET_TYPE_CONSUMED = 2;//消耗型dlc
            public const int PAY_TYPE_FREE = 0;//免费
            public const int PAY_TYPE_PAID = 1;//付费

            [JsonProperty(PropertyName = "aocCode")]
            public string sku;
            [JsonProperty(PropertyName = "aocName")]
            public string name;
            [JsonProperty(PropertyName = "itemType")]
            public int type;
            [JsonProperty(PropertyName = "chargeType")]
            public int payType;
            [JsonProperty(PropertyName = "originalPriceExtra")]
            public float originalPrice;
            [JsonProperty(PropertyName = "salePriceExtra")]
            public float salePrice;
            [JsonProperty(PropertyName = "aocBrief")]
            public string shortDescription;
            [JsonProperty(PropertyName = "iconUrl")]
            public string iconURL;

            public override string ToString()
            {
                return string.Format("sku:{0},name:{1},type:{2},payType:{3},originalPrice:{4},salePrice:{5},shortDescription:{6},iconURL:{7}", sku, name, type, payType, originalPrice, salePrice, shortDescription, iconURL);
            }
        }

        [Preserve]
        public class QiyuDlcAssetStatus
        {
            public const int DOWNLOAD_STATUS_AVAILABLE = 0;//可下载
            public const int DOWNLOAD_STATUS_DOWNLOADING = 1;//下载中
            public const int DOWNLOAD_STATUS_COMPLETE = 2;//下载完成
            public const int DOWNLOAD_STATUS_PENDING = 3;//下载暂停

            [JsonProperty(PropertyName = "aocCode")]
            public string sku;
            [JsonProperty(PropertyName = "purchased")]
            public bool purchased;
            [JsonProperty(PropertyName = "download_status")]
            public int downloadStatus;
            [JsonProperty(PropertyName = "path")]
            public string filePath;

            public override string ToString()
            {
                return string.Format("sku:{0},purchaseStatus:{1},downloadStatus:{2},filePath:{3}", sku, purchased, downloadStatus, filePath);
            }
        }

        [Preserve]
        public class QiyuDlcNotifications
        {
            public const string CODE_COMPLETE = "S0000";//下载完成
            public const string CODE_ERROR = "C1000";  // 未知错误
            public const string CODE_MD5_FAILED = "C1001";  // MD5校验失败
            public const string CODE_LOW_STORAGE = "C1002";  // 文件储存空间不足
            public const string CODE_INTERUPT = "C1003";  // 接收数据被中断
            public const string CODE_SERVER_DISCONNECT = "C1004";  // 与服务器链接失败
            public const string CODE_INVALID_VERSION = "C1005";  // 资源不存在
            public const string CODE_DOWNLOADING = "C1006";  // DLC正在下载中

            [JsonProperty(PropertyName = "aocCode")]
            public string sku;
            public double currentSize;
            public double totalSize;
            public string code;
            public string filePath;

            public override string ToString()
            {
                return string.Format("sku:{0},currentSize:{1},totalSize:{2},code:{3},filePath:{4}", sku, currentSize.ToString("f3"), totalSize.ToString("f3"), code, filePath);
            }
        }
    }
}