﻿//=============================================================================
//
//          Copyright (c) 2022 Beijing Dreamagic Science and Technology Co.,Ltd.
//                          All Rights Reserved.
//
//=============================================================================
using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using UnityEngine;
namespace Qiyu.Sdk.Platform
{
    public static class QiyuDLC
    {
        /// <summary>
        /// 初始化接口
        /// </summary>
        /// <param name="callback"></param>
        public static void Init(RequestCallback callback)
        {
            if (!QiyuPlatform.IsAndroid)
                return;

            QiyuXRPlatformPlugin.QVR_InitDLC(QiyuMessageManager.AddRequest(callback));
        }


        /// <summary>
        /// 获取dlc列表
        /// </summary>
        /// <param name="callback"></param>
        /// <param name="curPage">分页查询的页号，默认查询第1页</param>
        /// <param name="pageSize">每页指定数量，默认每页显示10个</param>
        public static void GetAssetsList(RequestCallback callback, int curPage = 1, int pageSize = 10)
        {
            if (!QiyuPlatform.IsAndroid)
                return;

            QiyuXRPlatformPlugin.QVR_GetAssetsList(QiyuMessageManager.AddRequest(callback), curPage, pageSize);
        }

        /// <summary>
        /// 获取指定dlc状态
        /// </summary>
        /// <param name="callback"></param>
        /// <param name="sku">dlc的sku</param>
        public static void GetAssetStatus(RequestCallback callback, string sku)
        {
            if (!QiyuPlatform.IsAndroid)
                return;

            QiyuXRPlatformPlugin.QVR_GetAssetStatus(QiyuMessageManager.AddRequest(callback), sku);
        }

        /// <summary>
        /// 下载指定dlc
        /// </summary>
        /// <param name="callback"></param>
        /// <param name="sku">dlc的sku</param>
        public static void DownloadAsset(RequestCallback callback, string sku)
        {
            if (!QiyuPlatform.IsAndroid)
                return;

            QiyuXRPlatformPlugin.QVR_DownloadAsset(QiyuMessageManager.AddRequest(callback), sku);
        }

        /// <summary>
        /// 设置下载进度通知
        /// </summary>
        /// <param name="callback">回调函数</param>
        public static void SetDownloadUpdateCallBack(Action<QiyuMessage.QiyuDlcNotifications> callback)
        {
            if (!QiyuPlatform.IsAndroid)
                return;

            callbackInner = callback;
            QiyuXRPlatformPlugin.QVR_DownloadUpdateNotifications(DownloadUpdateCallBack);
        }
        private static Action<QiyuMessage.QiyuDlcNotifications> callbackInner;
        private static QiyuMessage.QiyuDlcNotifications notificationsInner = new QiyuMessage.QiyuDlcNotifications();

        [UnmanagedFunctionPointer(CallingConvention.Cdecl)]
        public delegate void CallBack(string sku, double now, double max, string status, string path);
        public static IntPtr DownloadUpdateCallBack
        {
            get
            {
                CallBack callback_delegate = OnDownloadUpdate;
                return Marshal.GetFunctionPointerForDelegate(callback_delegate);
            }
        }

        [AOT.MonoPInvokeCallback(typeof(CallBack))]
        public static void OnDownloadUpdate(string sku, double now, double max, string status, string path)
        {
            try
            {
                if (callbackInner != null)
                {
                    notificationsInner.sku = sku;
                    notificationsInner.currentSize = now;
                    notificationsInner.totalSize = max;
                    notificationsInner.code = status;
                    notificationsInner.filePath = path;
                    callbackInner(notificationsInner);
                }
            }
            catch (Exception e)
            {
                Debug.LogError(e.Message);
            }
        }
    }
}