﻿//=============================================================================
//
//          Copyright (c) 2022 Beijing Dreamagic Science and Technology Co.,Ltd.
//                          All Rights Reserved.
//
//=============================================================================

using System.Collections;
using System.Collections.Generic;
using Unity.XR.Qiyu;
using UnityEngine;

namespace Unity.XR.Qiyu
{
    public class SeeThroughChangeStatus
    {
        public const int AppOpen = 0;
        public const int AppClose = 1;
        public const int SystemOpen = 2;
        public const int SystemClose = 3;
    }

    public class QiyuSeeThrough : MonoBehaviour
    {
        private Camera mainCam;
        private CameraClearFlags clearFlags_save;
        private Color backgroundColor_save;

        private void Awake()
        {
            mainCam = this.GetComponent<Camera>();
            clearFlags_save = mainCam.clearFlags;
            backgroundColor_save = mainCam.backgroundColor;

            QiyuXRCore.RegisterSeeThroughCallback(OnSeeThroughChanged);
        }

        private void OnDestroy()
        {
            QiyuXRCore.UnRegisterSeeThroughCallback(OnSeeThroughChanged);
        }

        private void OnSeeThroughChanged(int flag)
        {
            Debug.Log("OnSeeThroughChanged:" + flag);
            if (flag == SeeThroughChangeStatus.AppOpen)
            {
                ModifyCameraParam_On();
            }
            else if (flag == SeeThroughChangeStatus.AppClose)
            {
                ModifyCameraParam_Off();
            }
        }

        private void ModifyCameraParam_On()
        {
            if (mainCam == null)
            {
                Debug.LogError("ModifyCameraParam_On: main Camera is null!");
                return;
            }

            mainCam.clearFlags = CameraClearFlags.SolidColor;
            mainCam.backgroundColor = new Color(0, 0, 0, 0);
        }

        private void ModifyCameraParam_Off()
        {
            if (mainCam == null)
            {
                Debug.LogError("ModifyCameraParam_Off: main Camera is null!");
                return;
            }

            mainCam.clearFlags = clearFlags_save;
            mainCam.backgroundColor = backgroundColor_save;
        }

        public static void EnableSeeThrough(bool enable)
        {
            Debug.Log("EnableSeeThrough:" + enable);
            if (enable && Camera.main.GetComponent<QiyuSeeThrough>() == null)
            {
                Camera.main.gameObject.AddComponent<QiyuSeeThrough>();
            }
            QiyuXRCore.EnableSeeThrough(enable);
        }
    }
}