//=============================================================================
//
//          Copyright (c) 2022 Beijing Dreamagic Science and Technology Co.,Ltd.
//                          All Rights Reserved.
//
//=============================================================================
using System;
using System.Collections.Generic;
using Unity.XR.Qiyu;
using UnityEngine;
using UnityEngine.Rendering;

namespace Qiyu.Overlay
{

    public enum OverLayType
    {
        Overlay=1,
        Underlay=0
    }

    public enum OverlayShape
    {
        Quad,
        Cylinder,
        Sphere,
        Customize
    }

    public enum MeshFace
    {
        Front,
        Back
    }

    //This Component need add to XR camera.
    public class QiyuOverlayManager : MonoBehaviour
    {
        public static  List<QiyuOverlay> qiyuOverlaysList = new List<QiyuOverlay>();
        public static Action onPipelinePostRenderAction;

        private void Awake()
        {
            NativeMethods.SetLayerRenderQuality(1.3f);
        }

        private void OnEnable()
        {
#if UNITY_2019_1_OR_NEWER
            if (GraphicsSettings.renderPipelineAsset != null)
            {
                RenderPipelineManager.beginCameraRendering += BeginCameraRendering;
                RenderPipelineManager.endCameraRendering += EndCameraRendering;
            }
            else
            {
                Camera.onPreRender += OnPreRenderCallBack;
                Camera.onPostRender += OnPostRenderCallBack;
            }
#endif
        }

        private void OnDisable()
        {
#if UNITY_2019_1_OR_NEWER
            if (GraphicsSettings.renderPipelineAsset != null)
            {
                RenderPipelineManager.beginCameraRendering -= BeginCameraRendering;
                RenderPipelineManager.endCameraRendering -= EndCameraRendering;
            }
            else
            {
                Camera.onPreRender -= OnPreRenderCallBack;
                Camera.onPostRender -= OnPostRenderCallBack;
            }
#endif
        }

        private void BeginCameraRendering(ScriptableRenderContext contex, Camera camera)
        {
            OnPreRenderCallBack(camera);
        }

        private void EndCameraRendering(ScriptableRenderContext contex, Camera camera)
        {
            OnPostRenderCallBack(camera);
        }

        private void OnPreRenderCallBack(Camera camera)
        {
            
        }

        private void OnPostRenderCallBack(Camera camera)
        {
            onPipelinePostRenderAction?.Invoke();
            foreach (var qiyuOverlay in qiyuOverlaysList)
            {
                if (qiyuOverlay.gameObject != null && qiyuOverlay.isMeshInit)
                {
                    qiyuOverlay.SetCameraInfo(GetComponent<Camera>());
                    qiyuOverlay.UpdateModelInfo();
                }
            }
        }

        private void OnDestroy()
        {
            foreach (var overlay in qiyuOverlaysList)
            {
                overlay.RemoveOverlay();
            }
            qiyuOverlaysList.Clear();
        }
    }
}

