﻿//=============================================================================
//
//          Copyright (c) 2022 Beijing Dreamagic Science and Technology Co.,Ltd.
//                          All Rights Reserved.
//
//=============================================================================
using System;
using UnityEngine;
using UnityEngine.XR;

namespace Unity.XR.Qiyu
{
    public class QiyuVisualBase : MonoBehaviour
    {
        public QiyuHand _hand = QiyuHand.L;

        public InputDevice deviceHand;

        private void Start()
        {
            //Modify Ray Offset
            if (_hand == QiyuHand.L)
            {
                var LeftHandRay = GameObject.Find("[LeftHand Controller] Original Attach");
                //兼容toolkit 2.0
                if (LeftHandRay == null)
                {
                    LeftHandRay = GameObject.Find("[LeftHand Controller] Ray Origin");
                }
                if (LeftHandRay)
                {
                    LeftHandRay.transform.localPosition = new Vector3(0, -0.045f, 0.015f);
                    //LeftHandRay.transform.localEulerAngles = new Vector3(40, 0, 0);
                }
            }
            else if (_hand == QiyuHand.R)
            {
                var RightHandRay = GameObject.Find("[RightHand Controller] Original Attach");
                //兼容toolkit 2.0
                if (RightHandRay == null) {
                    RightHandRay = GameObject.Find("[RightHand Controller] Ray Origin");
                }

                if (RightHandRay)
                {
                    RightHandRay.transform.localPosition = new Vector3(0, -0.045f, 0.015f);
                    //RightHandRay.transform.localEulerAngles = new Vector3(40, 0, 0);
                }
            }

            if (_hand == QiyuHand.L)
            {
                deviceHand = UnityEngine.XR.InputDevices.GetDeviceAtXRNode(UnityEngine.XR.XRNode.LeftHand);
            }
            else
            {
                deviceHand = UnityEngine.XR.InputDevices.GetDeviceAtXRNode(UnityEngine.XR.XRNode.RightHand);
            }
        }
    }
}
