﻿//=============================================================================
//
//          Copyright (c) 2022 Beijing Dreamagic Science and Technology Co.,Ltd.
//                          All Rights Reserved.
//
//=============================================================================
using System.Collections;
using System.Collections.Generic;
using UnityEditor;
using UnityEngine;



public class QiyuDirectPreviewEditorWindow : EditorWindow
{
    static QiyuDirectPreviewEditorWindow instance;

    private string[] connect_type_names = new string[] { "USB"};
    private int[] connect_type_values = new int[] { 0,1};

    private string[] fps_names = new string[] {"30 FPS", "60 FPS", "72 FPS" };
    private int[] fps_value = { 30, 60, 72};

    private string[] eye_buffer_size_names = new string[] { "1080 * 1080", "1600 * 1600", "1920 * 1920"};
    private int[] eye_buffer_size_value = { 1080,1600,1920 };

    private readonly string DEFAULT_CONNECT_TYPE = "QIYU_DEFAULT_CONNECT_TYPE";
    private readonly string DEFAULT_FPS = "QIYU_DEFAULT_FPS";
    private readonly string DEFAULT_EYE_BUFFER_SIZE = "QIYU_DEFAULT_EYE_BUFFER_SIZE";
    private readonly string DEFAULT_IP_ADDRESS = "QIYU_DEFAULT_IP_ADDRESS";
    private readonly string DEFAULT_IP_PORT = "QIYU_DEFAULT_IP_PORT";

    private readonly string DEFAULT_IP_ADDRESS_USB = "QIYU_DEFAULT_IP_ADDRESS_USB";
    private readonly string DEFAULT_IP_PORT_USB = "QIYU_DEFAULT_IP_PORT_USB";


    public int prevSelectConnectType;
    public int selectConnectType;
    public int prevSelectFps;
    public int selectFPS;
    public int prevSelectEyebufferSize;
    public int selectEyebufferSize;

    public string prevIPAddress;
    public string ip_address;
    public int prevPort;
    public int port;

    public int prevPort_usb;
    public int port_usb;

    public static void Init()
    {
        if (instance == null)
        {
            instance = (QiyuDirectPreviewEditorWindow)GetWindow(typeof(QiyuDirectPreviewEditorWindow));
            instance.minSize = new Vector2(500, 500);
            instance.maxSize = new Vector2(500, 500);
            instance.Show();
        }
        else
        {
            instance.Show();
            instance.Focus();
        }
    }

    void GetDefaultSetting()
    {
        if (EditorPrefs.HasKey(DEFAULT_FPS))
        {
            prevSelectFps = EditorPrefs.GetInt(DEFAULT_FPS);

            bool isFind = false;
            for (int i = 0; i < fps_value.Length; i++)
            {
                if (prevSelectFps == fps_value[i])
                {
                    isFind = true;
                    break;
                }
            }
            if (!isFind)
                prevSelectFps = 60;
        }
        else
        {
            prevSelectFps = 60;
        }
        if (EditorPrefs.HasKey(DEFAULT_EYE_BUFFER_SIZE))
        {
            prevSelectEyebufferSize = EditorPrefs.GetInt(DEFAULT_EYE_BUFFER_SIZE);
            bool isFind = false;
            for (int i = 0; i < eye_buffer_size_value.Length; i++)
            {
                if (prevSelectEyebufferSize == eye_buffer_size_value[i])
                {
                    isFind = true;
                    break;
                }
            }
            if (!isFind)
                prevSelectEyebufferSize = 1600;
        }
        else
        {
            prevSelectEyebufferSize = 1600;
        }

        if (EditorPrefs.HasKey(DEFAULT_CONNECT_TYPE))
        {
            prevSelectConnectType = EditorPrefs.GetInt(DEFAULT_CONNECT_TYPE);
            bool isFind = false;
            for (int i = 0; i < connect_type_values.Length; i++)
            {
                if (prevSelectEyebufferSize == connect_type_values[i])
                {
                    isFind = true;
                    break;
                }
            }
            if (!isFind)
                prevSelectConnectType = 0;
        }
        else
        {
            prevSelectConnectType = 0;
        }
        if (EditorPrefs.HasKey(DEFAULT_IP_ADDRESS))
        {
            prevIPAddress = EditorPrefs.GetString(DEFAULT_IP_ADDRESS);
        }
        else
        {
            prevIPAddress = "192.168.1.100";
        }
        if (EditorPrefs.HasKey(DEFAULT_IP_PORT))
        {
            prevPort = EditorPrefs.GetInt(DEFAULT_IP_PORT);
        }
        else
        {
            prevPort = 45999;
        }
        if (EditorPrefs.HasKey(DEFAULT_IP_PORT_USB))
        {
            prevPort_usb = EditorPrefs.GetInt(DEFAULT_IP_PORT_USB);
        }
        else
        {
            prevPort_usb = 45999;
        }
    }

    private void OnInspectorUpdate()
    {
        Repaint();
    }

    void OnGUI()
    {
        GetDefaultSetting();

        GUILayout.Space(5.0f);
        GUILayout.Label("Direct Preview Setting", EditorStyles.boldLabel);
        GUILayout.Space(5.0f);

        selectConnectType = EditorGUILayout.IntPopup("Connect type:", prevSelectConnectType,connect_type_names,connect_type_values, new[] { GUILayout.Width(300) });
        if (selectConnectType != prevSelectConnectType)
        {
            EditorPrefs.SetInt(DEFAULT_CONNECT_TYPE, selectConnectType);
        }
        GUILayout.Space(20.0f);

        if (selectConnectType == 1)
        {
            EditorGUILayout.BeginHorizontal();
            EditorGUILayout.LabelField("Device ip address:", new[] { GUILayout.Width(150) });
            ip_address = EditorGUILayout.TextField(prevIPAddress, new[] { GUILayout.Width(150) }).Trim();
            if (ip_address != prevIPAddress)
            {
                EditorPrefs.SetString(DEFAULT_IP_ADDRESS, ip_address);
            }
            EditorGUILayout.LabelField("IP Port:", new[] { GUILayout.Width(50) });
            port = EditorGUILayout.IntField(prevPort, new[] { GUILayout.Width(100) });
            if (port != prevPort)
            {
                EditorPrefs.SetInt(DEFAULT_IP_PORT, port);
            }
            EditorGUILayout.EndHorizontal();
            GUILayout.Space(20.0f);
        }
        else
        {
            EditorGUILayout.BeginHorizontal();
            EditorGUILayout.LabelField("IP Port:", new[] { GUILayout.Width(150) });
            port_usb = EditorGUILayout.IntField(prevPort_usb, new[] { GUILayout.Width(100) });
            if (port_usb != prevPort_usb)
            {
                EditorPrefs.SetInt(DEFAULT_IP_PORT_USB, port_usb);
            }
            EditorGUILayout.EndHorizontal();
            GUILayout.Space(20.0f);
        }

        selectFPS = EditorGUILayout.IntPopup("Render Frame:", prevSelectFps, fps_names, fps_value,new[] { GUILayout.Width(300) });
        if (selectFPS != prevSelectFps)
        {
            EditorPrefs.SetInt(DEFAULT_FPS, selectFPS);
        }
        GUILayout.Space(20.0f);

        selectEyebufferSize = EditorGUILayout.IntPopup("Render Resolution:", prevSelectEyebufferSize,eye_buffer_size_names,eye_buffer_size_value, new[] { GUILayout.Width(300) });
        if (selectEyebufferSize != prevSelectEyebufferSize)
        {
            EditorPrefs.SetInt(DEFAULT_EYE_BUFFER_SIZE,selectEyebufferSize);
        }
        GUILayout.Space(20.0f);

        //EditorGUILayout.BeginHorizontal();
        //{
        //    GUILayout.Space(150f);
        //    string install_text = "install preview apk";
        //    var sceneSelectBtn = GUILayoutUtility.GetRect(new GUIContent(install_text), GUI.skin.button, new[] {GUILayout.Height(25), GUILayout.Width(200) });
        //    if (GUI.Button(sceneSelectBtn, install_text))
        //    {
        //        QiyuDirectPreviewManager.GetMe().InstallDirectPreviewApk();
        //    };
        //}
        //EditorGUILayout.EndHorizontal();
        //GUILayout.Space(20f);
        //EditorGUILayout.BeginHorizontal();
        //{
        //    GUILayout.Space(150f);
        //    string uninstall_text = "uninstall preview apk";
        //    var sceneSelectBtn = GUILayoutUtility.GetRect(new GUIContent(uninstall_text), GUI.skin.button, new[] { GUILayout.Height(25), GUILayout.Width(200) });
        //    if (GUI.Button(sceneSelectBtn, uninstall_text))
        //    {
        //        QiyuDirectPreviewManager.GetMe().UninstallDirectPreviewApk();
        //    };
        //}
        //EditorGUILayout.EndHorizontal();

        //GUILayout.Space(20f);
        //EditorGUILayout.BeginHorizontal();
        //{
        //    GUILayout.Space(150f);
        //    string start_app_text = "start preview app";
        //    var sceneSelectBtn = GUILayoutUtility.GetRect(new GUIContent(start_app_text), GUI.skin.button, new[] { GUILayout.Height(25), GUILayout.Width(200) });
        //    if (GUI.Button(sceneSelectBtn, start_app_text))
        //    {
        //        QiyuDirectPreviewManager.GetMe().StartDirectPreviewApp();
        //    };
        //}
        //EditorGUILayout.EndHorizontal();
        //GUILayout.Space(20f);

        EditorGUILayout.BeginHorizontal();
        {
            GUILayout.Space(150f);
            string connect_text = "Connect Qiyu Device";
            var sceneSelectBtn = GUILayoutUtility.GetRect(new GUIContent(connect_text), GUI.skin.button, new[] { GUILayout.Height(25), GUILayout.Width(200) });
            if (GUI.Button(sceneSelectBtn, connect_text))
            {
                PreviewSettings previewSettings = new PreviewSettings();
                previewSettings.connectType = selectConnectType;
                previewSettings.ip = selectConnectType == 0 ? "127.0.0.1" : ip_address;
                previewSettings.port = selectConnectType == 0 ? port_usb : port;
                previewSettings.eyebufferSize = selectEyebufferSize;
                previewSettings.fps = selectFPS;
                if (QiyuDirectPreviewManager.GetMe().PushPreviewConfig(previewSettings))
                {
                    QiyuDirectPreviewManager.GetMe().ConnectDevice(previewSettings);
                }
                else
                {
                    Debug.LogError("push PushPreviewConfig error.");
                }
            };
        }
        EditorGUILayout.EndHorizontal();

        GUILayout.Space(10.0f);
        GUILayout.Label("Log Info", EditorStyles.boldLabel);

        if (!string.IsNullOrEmpty(log))
        {
            InitLogUI();
            GUILayout.Label(log, logStyle, GUILayout.Height(30.0f));
        }
    }

    static string log;
    static GUIStyle logStyle;
    public enum LogType
    {
        Normal,
        Success,
        Error
    }
    private static void InitLogUI()
    {
        if (logStyle == null)
        {
            logStyle = new GUIStyle();
            logStyle.margin.left = 5;
            logStyle.wordWrap = true;
            logStyle.normal.textColor = logStyle.focused.textColor = EditorStyles.label.normal.textColor;
            logStyle.richText = true;
        }
    }

    public static void PrintLog(string message, LogType type)
    {
        switch (type)
        {
            case LogType.Normal:
                {
                    log = message;
                    break;
                }
            case LogType.Success:
                {
                    log = "<color=green>Success!\n" + message + "</color>\n";
                    break;
                }
            case LogType.Error:
                {
                    log = "<color=red>Failed!\n" + message + "</color>\n";
                    break;
                }
        }
    }
}
