using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class Main : MonoBehaviour
{
    [SerializeField]
    private Transform[] _DinosaurArray;

    [SerializeField]
    private Button _ChangeBtn;

    [SerializeField]
    private Button[] _BeHaviourBtns;

    private Transform _dinousaurCurrent;

    private int indexCurrent = 0;

    private Animator _animatorCurrent;

    private DinosaurBase _dinosaurBase;

    void Start()
    {

        for (int i = 0; i < _DinosaurArray.Length; i++)
        {
            _DinosaurArray[i].gameObject.SetActive(false);
        }

        Change(indexCurrent);

        _ChangeBtn.onClick.AddListener(()=> { ChangeDinosaur(); });

        _BeHaviourBtns[0].onClick.AddListener(() => { BeHaviour(0); });
        _BeHaviourBtns[1].onClick.AddListener(() => { BeHaviour(1); });
        _BeHaviourBtns[2].onClick.AddListener(() => { BeHaviour(2); });
        _BeHaviourBtns[3].onClick.AddListener(() => { BeHaviour(3); });
    }

    void Update()
    {

        if (Input.GetKeyDown(KeyCode.Space))
        {
            ChangeDinosaur();
        }
    }

    //л
    private void ChangeDinosaur()
    {
        indexCurrent += 1;
        indexCurrent = indexCurrent >= _DinosaurArray.Length ? 0 : indexCurrent;
        Change(indexCurrent);
    }

    private void Change(int index)
    {
        if (_dinousaurCurrent) _dinousaurCurrent.gameObject.SetActive(false);
        _dinousaurCurrent = _DinosaurArray[index];
        _dinousaurCurrent.gameObject.SetActive(true);
        _animatorCurrent = _dinousaurCurrent.GetComponent<Animator>();
        _dinosaurBase = _dinousaurCurrent.GetComponent<DinosaurBase>();
        _dinosaurBase.Init();

        EBehaviour[] edinousaur = _dinosaurBase._enum_behaviours;
        for (int i = 0; i < _BeHaviourBtns.Length; i++)
        {
            _BeHaviourBtns[i].transform.GetChild(0).GetComponent<Text>().text = edinousaur[i].ToString();
        }
    }

    //Ϊ
    private void BeHaviour(int indexs)
    {
        _dinosaurBase.BeHaviour(indexs);
    }
}

public enum EDinousaur
{
    Carnotaurus,
    Styracosaurus,
    Tyrannosaurus
}

public enum EBehaviour
{
    yaoren,
    walk,
    attack,
    zhuangqiang,
    haojiao,
    run,
    food,
    bone
}
