using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DinosaurBase : MonoBehaviour
{
    [SerializeField]
    private Animator _animator = null;

    public EDinousaur _dianousaurTpye;

    public EBehaviour[] _enum_behaviours;

    [SerializeField]
    private float powerScale = 20;

    [SerializeField]
    private AudioSource _audio;

    [SerializeField]
    private AudioClip[] _audioClips;
    void Start()
    {
        transform.localScale = new Vector3(powerScale, powerScale, powerScale);
        BeHaviour(3);
        AddAnimationEvent(_enum_behaviours[0].ToString(), "PlayAudio01", 0);
        AddAnimationEvent(_enum_behaviours[1].ToString(), "PlayAudio02", 0);
        AddAnimationEvent(_enum_behaviours[2].ToString(), "PlayAudio03", 0);
        AddAnimationEvent(_enum_behaviours[3].ToString(), "PlayAudio04", 0);
    }

    private void PlayAudio01()
    {
        PlayAudio(0);
    }

    private void PlayAudio02()
    {
        PlayAudio(1);
    }

    private void PlayAudio03()
    {
        PlayAudio(2);
    }
    private void PlayAudio04()
    {
        PlayAudio(3);
    }

    private void PlayAudio(int index)
    {
        _audio.clip = _audioClips[index];
        _audio.Play();
    }
  
    public void Init()
    {

    }

    public void BeHaviour(int index)
    {
        _animator.Play(_enum_behaviours[index].ToString(), 0);
        SetLocation(index);;
    }

    private Vector3 postion, euler;
   
    public void SetLocation(int behaviourIndex)
    {
        switch (_dianousaurTpye)
        {
            case EDinousaur.Carnotaurus:
                postion = new Vector3(0, -6F, -5.49f / 20 * powerScale);
                euler = new Vector3(0, 5, 0);
                switch (behaviourIndex)
                {
                    case 0:
                        postion = new Vector3(-2f / 20 * powerScale, -6F, -7.53f / 20 * powerScale);
                        euler = new Vector3(0, 51.4f, 0);
                        break;
                    case 1:
                        postion = new Vector3(2.61f / 20 * powerScale, -6F, -5f / 20 * powerScale);
                        euler = new Vector3(0, 0, 0);
                        break;
                    case 2:
                        postion = new Vector3(2.7f / 20 * powerScale, -6F, -6.89f / 20 * powerScale);
                        euler = new Vector3(0, 0, 0);
                        break;
                    default:
                        break;
                }
                break;
            case EDinousaur.Styracosaurus:
                postion = new Vector3(0, -6F, -5.5f / 20 * powerScale);
                euler = new Vector3(0, -20, 0);
                switch (behaviourIndex)
                {
                    case 0:
                        postion = new Vector3(0, -7F, -13.4f / 20 * powerScale);
                        euler = new Vector3(0, 0, 0);
                        break;
                    case 1:
                        break;
                    case 2:
                        postion = new Vector3(0, -7F, -9.15f / 20 * powerScale);
                        euler = new Vector3(0, 0, 0);
                        break;
                    default:
                        break;
                }
                break;
            case EDinousaur.Tyrannosaurus:
                postion = new Vector3(1.5f / 20 * powerScale, -8, -8f / 20 * powerScale);
                euler = new Vector3(0, -45, 0);
                switch (behaviourIndex)
                {
                    case 0:
                        postion = new Vector3(1.5f / 20 * powerScale, -8, -3f / 20 * powerScale);
                        euler = new Vector3(0, -90, 0);
                        break;
                    case 1:
                        postion = new Vector3(-1.45f / 20 * powerScale, -10, -17.5f / 20 * powerScale);
                        euler = new Vector3(0, 17.6f, 0);
                        break;
                    case 2:
                        postion = new Vector3(0, -10, -23f / 20 * powerScale);
                        euler = new Vector3(0, 0, 0);
                        break;
                    default:
                        break;
                }
                break;
            default:
                break;
        }
        transform.localPosition = postion;
        transform.localEulerAngles = euler;
    }
    private void AddAnimationEvent(string _clipName, string _eventFunctionName, float _time)
    {
        AnimationClip[] _clips = _animator.runtimeAnimatorController.animationClips;
        for (int i = 0; i < _clips.Length; i++)
        {
            
            if (_clips[i].name == _clipName)
            {
                //Debug.LogError(_clips[i].name);
                AnimationEvent _event = new AnimationEvent();
                _event.functionName = _eventFunctionName;
                _event.time = _time;
                _clips[i].AddEvent(_event);
                break;
            }
        }
        _animator.Rebind();
    }
}
